unit Ledlp_1a;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, Buttons, ExtCtrls, TypInfo,
  Ledlp;

type
  TLEditForm = class(TForm)
    ButtonPanel: TPanel;
    NewBtn: TSpeedButton;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    SaveAsBtn: TSpeedButton;
    ReloadBtn: TSpeedButton;
    UndoBtn: TSpeedButton;
    RedoBtn: TSpeedButton;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    FindBtn: TSpeedButton;
    ReplaceBtn: TSpeedButton;
    GotoBtn: TSpeedButton;
    ForeColorBtn: TSpeedButton;
    BackColorBtn: TSpeedButton;
    SelForeColorBtn: TSpeedButton;
    SelBackColorSel: TSpeedButton;
    PopupMenu1: TPopupMenu;
    UndoPopupItem: TMenuItem;
    RedoPopupItem: TMenuItem;
    PopupLine1: TMenuItem;
    CutPopupItem: TMenuItem;
    CopyPopupItem: TMenuItem;
    PastePopupItem: TMenuItem;
    DeletePopupItem: TMenuItem;
    SelectAllPopupItem: TMenuItem;
    PopupLine2: TMenuItem;
    ClearPopupItem: TMenuItem;
    ClearAllPopupItem: TMenuItem;
    PopupLine3: TMenuItem;
    FindPopupItem: TMenuItem;
    ReplacePopupItem: TMenuItem;
    StatusPanel: TPanel;
    LineCountStatus: TPanel;
    TotalLineCount: TLabel;
    LineStatus: TPanel;
    LineNumber: TLabel;
    ColStatus: TPanel;
    ColNumber: TLabel;
    StatusLine: TPanel;
    LEdit1: TLEdit;
    ColorDialog: TColorDialog;
    SetBookmarkBtn: TSpeedButton;
    FindBookmarkBtn: TSpeedButton;
    AboutBtn: TSpeedButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu: TMainMenu;
    FileMenuItem: TMenuItem;
    NewMenuItem: TMenuItem;
    OpenMenuItem: TMenuItem;
    SaveMenuItem: TMenuItem;
    SaveAsMenuItem: TMenuItem;
    ReloadFileMenuItem: TMenuItem;
    N1: TMenuItem;
    PrinterSetupMenuItem: TMenuItem;
    PrintMenuItem: TMenuItem;
    N2: TMenuItem;
    ExitMenuItem: TMenuItem;
    EditMenuItem: TMenuItem;
    UndoMenuItem: TMenuItem;
    RedoMenuItem: TMenuItem;
    ClearUndoMenuItem: TMenuItem;
    Line2: TMenuItem;
    CutMenuItem: TMenuItem;
    CopyMenuItem: TMenuItem;
    PasteMenuItem: TMenuItem;
    DeleteMenuItem: TMenuItem;
    SelectAllMenuItem: TMenuItem;
    Line3: TMenuItem;
    ClearMenuItem: TMenuItem;
    ClearAllMenuItem: TMenuItem;
    Line4: TMenuItem;
    FindMenuItem: TMenuItem;
    FindNextMenuItem: TMenuItem;
    FindBraceMenuItem: TMenuItem;
    ReplaceMenuItem: TMenuItem;
    Line45: TMenuItem;
    GotoLineMenuItem: TMenuItem;
    OptionsMenuItem: TMenuItem;
    ForeColorMenuItem: TMenuItem;
    BackgroundColor1: TMenuItem;
    SelectForeColorMenuItem: TMenuItem;
    SelectBackColorMenuItem: TMenuItem;
    N3: TMenuItem;
    HeaderFooter1: TMenuItem;
    N5: TMenuItem;
    DisplayDialogs1: TMenuItem;
    Print1: TMenuItem;
    PrintProgress1: TMenuItem;
    Line5: TMenuItem;
    FontMenuItem: TMenuItem;
    ReadOnlyMenuItem: TMenuItem;
    CaretWidthMenuItem: TMenuItem;
    InsertModeMenuItem: TMenuItem;
    N4: TMenuItem;
    WordWrapMenuItem: TMenuItem;
    SetWordWrapMenuItem: TMenuItem;
    WWWidthMenuItem: TMenuItem;
    WWRMarginMenuItem: TMenuItem;
    Line6: TMenuItem;
    UnixStyleSaveMenuItem: TMenuItem;
    MacStyleSaveMenuItem: TMenuItem;
    BookmarksMenuItem: TMenuItem;
    SetBookmarkMenuItem: TMenuItem;
    SetBookmarkNumberMenuItem: TMenuItem;
    FindBookmarkMenuItem: TMenuItem;
    HelpMenuItem: TMenuItem;
    AboutMenuItem: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ExitMenuItemClick(Sender: TObject);
    procedure OpenMenuItemClick(Sender: TObject);
    procedure NewMenuItemClick(Sender: TObject);
    procedure SaveMenuItemClick(Sender: TObject);
    procedure SaveAsMenuItemClick(Sender: TObject);
    procedure ReloadFileMenuItemClick(Sender: TObject);
    procedure UndoMenuItemClick(Sender: TObject);
    procedure RedoMenuItemClick(Sender: TObject);
    procedure ClearUndoMenuItemClick(Sender: TObject);
    procedure CutMenuItemClick(Sender: TObject);
    procedure CopyMenuItemClick(Sender: TObject);
    procedure PasteMenuItemClick(Sender: TObject);
    procedure DeleteMenuItemClick(Sender: TObject);
    procedure SelectAllMenuItemClick(Sender: TObject);
    procedure ClearMenuItemClick(Sender: TObject);
    procedure ClearAllMenuItemClick(Sender: TObject);
    procedure FindMenuItemClick(Sender: TObject);
    procedure FindNextMenuItemClick(Sender: TObject);
    procedure FindBraceMenuItemClick(Sender: TObject);
    procedure ReplaceMenuItemClick(Sender: TObject);
    procedure GotoLineMenuItemClick(Sender: TObject);
    procedure FontMenuItemClick(Sender: TObject);
    procedure ReadOnlyMenuItemClick(Sender: TObject);
    procedure InsertModeMenuItemClick(Sender: TObject);
    procedure SetBookmarkMenuItemClick(Sender: TObject);
    procedure FindBookmarkMenuItemClick(Sender: TObject);
    procedure ForeColorMenuItemClick(Sender: TObject);
    procedure BackgroundColor1Click(Sender: TObject);
    procedure SelectForeColorMenuItemClick(Sender: TObject);
    procedure SelectBackColorMenuItemClick(Sender: TObject);
    procedure LEditChange(Sender: TObject);
    procedure UpdateMenuItems(Value: Boolean);
    procedure AboutMenuItemClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure UnixStyleSaveMenuItemClick(Sender: TObject);
    procedure MacStyleSaveMenuItemClick(Sender: TObject);
    procedure SetBookmarkNumberMenuItemClick(Sender: TObject);
    procedure PrintMenuItemClick(Sender: TObject);
    procedure PrinterSetupMenuItemClick(Sender: TObject);
    procedure HeaderFooter1Click(Sender: TObject);
    procedure LEdit1PrintPage(Sender: TObject; PrintDC: TCanvas;
      VerticalSize, HorizontalSize: Word; var HeaderSize,
      FooterSize: Word);
    procedure WWWidthMenuItemClick(Sender: TObject);
    procedure WWRMarginMenuItemClick(Sender: TObject);
    procedure WordWrapMenuItemClick(Sender: TObject);
    procedure CaretWidthMenuItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Print1Click(Sender: TObject);
    procedure PrintProgress1Click(Sender: TObject);
  private
    procedure ShowHint(Sender: TObject);
  public
    FBmNum: Word;
    FHeader: String;
    FFooter: String;
    WWWidth: Word;
    WWRMargin: Word;
    FCaretWidth: Word;
  end;

var
  LEditForm: TLEditForm;

implementation

{$R *.DFM}

uses ledlp_1b, ledlp_1c, ledlp_1d, ledlp_1e, ledlp_1f, ledlp_1z;

procedure TLEditForm.FormCreate(Sender: TObject);
begin
  { Set up the application }
  Application.OnHint := ShowHint;
  UpdateMenuItems(False);
  Application.HintColor := clAqua;
  Application.HintPause := 0;
  FHeader := '';
  FFooter := '';
end;

procedure TLEditForm.ShowHint(Sender: TObject);
begin
  StatusLine.Caption := Application.Hint;
end;

procedure TLEditForm.ExitMenuItemClick(Sender: TObject);
begin
  { End the application }
  Close;
end;

procedure TLEditForm.OpenMenuItemClick(Sender: TObject);
begin
  { Load a file into LEdit }
  if OpenDialog1.Execute then
  begin
    LEdit1.LoadFromFile(OpenDialog1.FileName);
    LEdit1.FileName := OpenDialog1.FileName;
    LEditForm.Caption := OpenDialog1.FileName;
  end;
end;

procedure TLEditForm.NewMenuItemClick(Sender: TObject);
begin
  { Start a new file in LEdit }
  LEdit1.NewFile;
  LEdit1.FileName := '';
  LEditForm.Caption := '';
  UpdateMenuItems(False);
end;

procedure TLEditForm.SaveMenuItemClick(Sender: TObject);
begin
  { Save the current LEdit contents to a file }
  LEdit1.SaveFile;
  LEditForm.Caption := LEdit1.FileName;
end;

procedure TLEditForm.SaveAsMenuItemClick(Sender: TObject);
begin
  { Save the current LEdit contents to a new file }
  LEdit1.SaveFileAs;
  LEditForm.Caption := LEdit1.FileName;
end;

procedure TLEditForm.ReloadFileMenuItemClick(Sender: TObject);
begin
  { Reload the current file into LEdit }
  LEdit1.ReloadFile;
end;

procedure TLEditForm.UndoMenuItemClick(Sender: TObject);
begin
  { Undo the last action }
  LEdit1.Undo;
  if LEdit1.CanRedo then
  begin
    RedoMenuItem.Enabled := True;
    RedoBtn.Enabled := True;
  end
  else
  begin
    RedoMenuItem.Enabled := False;
    RedoBtn.Enabled := False;
  end;
end;

procedure TLEditForm.RedoMenuItemClick(Sender: TObject);
begin
  { Redo the last undo }
  LEdit1.Redo;
  if LEdit1.CanUndo then
  begin
    UndoMenuItem.Enabled := True;
    UndoBtn.Enabled := True;
  end
  else
  begin
    UndoMenuItem.Enabled := False;
    UndoBtn.Enabled := False;
  end;
end;

procedure TLEditForm.ClearUndoMenuItemClick(Sender: TObject);
begin
  { Clear the undo buffer }
  LEdit1.EmptyUndoBuffer;
  { Set the undo menu item status }
  if LEdit1.CanUndo then
  begin
    UndoMenuItem.Enabled := True;
    UndoBtn.Enabled := True;
  end
  else
  begin
    UndoMenuItem.Enabled := False;
    UndoBtn.Enabled := False;
  end;
  { Set the redo menu item status }
  if LEdit1.CanRedo then
  begin
    RedoMenuItem.Enabled := True;
    RedoBtn.Enabled := True;
  end
  else
  begin
    RedoMenuItem.Enabled := False;
    RedoBtn.Enabled := False;
  end;
end;

procedure TLEditForm.CutMenuItemClick(Sender: TObject);
begin
  { Cut the selection and place it on the windows clipboard }
  LEdit1.CutToClipboard;
end;

procedure TLEditForm.CopyMenuItemClick(Sender: TObject);
begin
  { Copy the selection to the windows clipboard but do not cut it }
  LEdit1.CopyToClipboard;
end;

procedure TLEditForm.PasteMenuItemClick(Sender: TObject);
begin
  { Paste the contents of the windows clipboard into LEdit }
  LEdit1.PasteFromClipboard;
end;

procedure TLEditForm.DeleteMenuItemClick(Sender: TObject);
begin
  { Delete the selected text }
  LEdit1.ClearSelection;
end;

procedure TLEditForm.SelectAllMenuItemClick(Sender: TObject);
begin
  { Select all the text in LEdit }
  LEdit1.SelectAll;
end;

procedure TLEditForm.ClearMenuItemClick(Sender: TObject);
begin
  { Clear the selected text from LEdit }
  LEdit1.ClearSelection;
end;

procedure TLEditForm.ClearAllMenuItemClick(Sender: TObject);
begin
  { Clear all the text from LEdit }
  LEdit1.Clear;
end;

procedure TLEditForm.FindMenuItemClick(Sender: TObject);
begin
  { Show the Find dialog to perform a search }
  LEdit1.ShowFindDialog;
end;

procedure TLEditForm.FindNextMenuItemClick(Sender: TObject);
begin
  { Find the next occurance of the search }
  LEdit1.FindNext;
end;

procedure TLEditForm.FindBraceMenuItemClick(Sender: TObject);
begin
  { Find the next brace }
  LEdit1.FindBrace;
end;

procedure TLEditForm.ReplaceMenuItemClick(Sender: TObject);
begin
  { Show the Replace dialog to replace text searched for }
  LEdit1.ShowReplaceDialog;
end;

procedure TLEditForm.GotoLineMenuItemClick(Sender: TObject);
begin
  { Show the Goto Line dialog to go to a specific line }
  LEdit1.ShowGotoLineDialog;
end;

procedure TLEditForm.FontMenuItemClick(Sender: TObject);
begin
  { Show the Font dialog to set the font }
  LEdit1.ShowFontDialog;
end;

procedure TLEditForm.ReadOnlyMenuItemClick(Sender: TObject);
begin
  { Toggle LEdit to Read only or not Read Only mode }
  ReadOnlyMenuItem.Checked := not ReadOnlyMenuItem.Checked;
  LEdit1.ReadOnly := not LEdit1.ReadOnly;
end;

procedure TLEditForm.InsertModeMenuItemClick(Sender: TObject);
begin
  { Toggle LEdit to Insert or Overwrite mode }
  InsertModeMenuItem.Checked := not InsertModeMenuItem.Checked;
  LEdit1.InsertMode := not LEdit1.InsertMode;
end;

procedure TLEditForm.SetBookmarkMenuItemClick(Sender: TObject);
begin
  { Set a bookmark }
  LEdit1.SetBookmark;
end;

procedure TLEditForm.FindBookmarkMenuItemClick(Sender: TObject);
begin
  { Go to the bookmark }
  LEdit1.FindBookmark;
end;

procedure TLEditForm.ForeColorMenuItemClick(Sender: TObject);
begin
  { Display a color dialog and set the foreground (text) color of LEdit }
  if ColorDialog.Execute then
    LEdit1.Font.Color := ColorDialog.Color;
end;

procedure TLEditForm.BackgroundColor1Click(Sender: TObject);
begin
  { Display a color dialog and set the background color of LEdit }
  if ColorDialog.Execute then
    LEdit1.Color := ColorDialog.Color;
end;

procedure TLEditForm.SelectForeColorMenuItemClick(Sender: TObject);
begin
  { Display a color dialog and set the selection foreground color of LEdit }
  if ColorDialog.Execute then
    LEdit1.ForeColorSelected := ColorDialog.Color;
end;

procedure TLEditForm.SelectBackColorMenuItemClick(Sender: TObject);
begin
  { Display a color dialog and set the selection background color of LEdit }
  if ColorDialog.Execute then
    LEdit1.BackColorSelected := ColorDialog.Color;
end;

procedure TLEditForm.LEditChange(Sender: TObject);
begin
  { Set the status bar counts }
  TotalLineCount.Caption := IntToStr(LEdit1.LineCount);
  LEdit1.GetSelection;
  LineNumber.Caption := IntToStr(LEdit1.EndLine);
  ColNumber.Caption := IntToStr(LEdit1.EndPos);
  UpdateMenuItems(True);
end;

procedure TLEditForm.UpdateMenuItems(Value: Boolean);
begin
  SaveMenuItem.Enabled := Value;
  SaveAsMenuItem.Enabled := Value;
  ReloadFileMenuItem.Enabled := Value;
  CutMenuItem.Enabled := Value;
  CopyMenuItem.Enabled := Value;
  PasteMenuItem.Enabled := Value;
  DeleteMenuItem.Enabled := Value;
  SelectAllMenuItem.Enabled := Value;
  ClearMenuItem.Enabled := Value;
  ClearAllMenuItem.Enabled := Value;
  FindMenuItem.Enabled := Value;
  FindNextMenuItem.Enabled := Value;
  FindBraceMenuItem.Enabled := Value;
  ReplaceMenuItem.Enabled := Value;
  GotoLineMenuItem.Enabled := Value;
  SetBookmarkMenuItem.Enabled := Value;
  FindBookmarkMenuItem.Enabled := Value;
  SaveBtn.Enabled := Value;
  SaveAsBtn.Enabled := Value;
  ReloadBtn.Enabled := Value;
  CutBtn.Enabled := Value;
  CopyBtn.Enabled := Value;
  PasteBtn.Enabled := Value;
  FindBtn.Enabled := Value;
  ReplaceBtn.Enabled := Value;
  GotoBtn.Enabled := Value;
  SetBookmarkBtn.Enabled := Value;
  FindBookmarkBtn.Enabled := Value;
  { Set the undo menu item status }
  if LEdit1.CanUndo then
  begin
    UndoMenuItem.Enabled := True;
    UndoBtn.Enabled := True;
  end
  else
  begin
    UndoMenuItem.Enabled := False;
    UndoBtn.Enabled := False;
  end;
  { Set the redo menu item status }
  if LEdit1.CanRedo then
  begin
    RedoMenuItem.Enabled := True;
    RedoBtn.Enabled := True;
  end
  else
  begin
    RedoMenuItem.Enabled := False;
    RedoBtn.Enabled := False;
  end;
end;

procedure TLEditForm.AboutMenuItemClick(Sender: TObject);
begin
  { Show about box }
  LEExAboutBox.ShowModal;
end;

procedure TLEditForm.FormShow(Sender: TObject);
begin
  { Open/Save dialog position }
  LEdit1.SetDialogLocation(25, 25, dsOpenSave);
  { Print dialog position }
  LEdit1.SetDialogLocation(100, 25, dsPrint);
  { Print Progress dialog position to default }
  LEdit1.SetDialogLocation(-1, -1, dsPrintProgress);
  { Set WrapKeys to automatically wrap the cursor like Notepad }
  LEdit1.WrapKeys := True;

  if ParamStr(1) <> '' then    { Check the input parameter and if set, load the file }
    LEdit1.LoadFromFile(ParamStr(1));
end;

procedure TLEditForm.UnixStyleSaveMenuItemClick(Sender: TObject);
begin
  { Turn off Mac Style Save if it is on }
  if MacStyleSaveMenuItem.Checked then
  begin
    MacStyleSaveMenuItem.Checked := not MacStyleSaveMenuItem.Checked;
    LEdit1.MacStyleSave := MacStyleSaveMenuItem.Checked;
  end;
  { Toggle LEdit to Unix Style Save on or off }
  UnixStyleSaveMenuItem.Checked := not UnixStyleSaveMenuItem.Checked;
  LEdit1.UnixStyleSave := UnixStyleSaveMenuItem.Checked;
end;

procedure TLEditForm.MacStyleSaveMenuItemClick(Sender: TObject);
begin
  { Turn off Unix Style Save if it is on }
  if UnixStyleSaveMenuItem.Checked then
  begin
    UnixStyleSaveMenuItem.Checked := not UnixStyleSaveMenuItem.Checked;
    LEdit1.UnixStyleSave := UnixStyleSaveMenuItem.Checked;
  end;
  { Toggle LEdit to Mac Style Save on or off }
  MacStyleSaveMenuItem.Checked := not MacStyleSaveMenuItem.Checked;
  LEdit1.MacStyleSave := MacStyleSaveMenuItem.Checked;
end;

procedure TLEditForm.SetBookmarkNumberMenuItemClick(Sender: TObject);
begin
  BookmarkNumberForm.BookmarkNumberEdit.Text := IntToStr(LEdit1.BookmarkNumber);
  if BookmarkNumberForm.ShowModal = mrOK then
  begin
    LEdit1.BookmarkNumber := FBmNum;
    { Set a bookmark }
    LEdit1.SetBookmark;
  end;
end;

procedure TLEditForm.PrintMenuItemClick(Sender: TObject);
begin
  LEdit1.Print;
end;

procedure TLEditForm.PrinterSetupMenuItemClick(Sender: TObject);
begin
  LEdit1.PrinterSetup;
end;

procedure TLEditForm.HeaderFooter1Click(Sender: TObject);
begin
  HeaderFooterForm.Edit1.Text := FHeader;
  HeaderFooterForm.Edit2.Text := FFooter;
  HeaderFooterForm.ShowModal;
end;

procedure TLEditForm.LEdit1PrintPage(Sender: TObject; PrintDC: TCanvas;
  VerticalSize, HorizontalSize: Word; var HeaderSize, FooterSize: Word);
var
  HRect, FRect: TRect;
begin
  { Set Header Rectangle }
  HRect.Left := 0;
  HRect.Right := HorizontalSize;
  HRect.Top := 10;
  HRect.Bottom := HRect.Top + 20;
  { Set Footer Rectangle }
  FRect.Left := 0;
  FRect.Right := HorizontalSize;
  FRect.Top := VerticalSize - 50;
  FRect.Bottom := FRect.Top + 20;
  { Write the Header }
  PrintDC.TextRect(HRect, HRect.Left + 5, HRect.Top + 2, FHeader);
  { Write the Footer }
  PrintDC.TextRect(FRect, FRect.Left + 5, FRect.Top + 2, FFooter);
  { Set the return values }
  HeaderSize := 40;
  FooterSize := 50;
end;

procedure TLEditForm.WWWidthMenuItemClick(Sender: TObject);
begin
  WWWidthForm.WWWidthEdit.Text := IntToStr(LEdit1.WordWrapWidth);
  if WWWidthForm.ShowModal = mrOK then
  begin
    LEdit1.WordWrapWidth := WWWidth;
  end;
end;

procedure TLEditForm.WWRMarginMenuItemClick(Sender: TObject);
begin
  WWRMarginForm.WWRMarginEdit.Text := IntToStr(LEdit1.WordWrapRMargin);
  if WWRMarginForm.ShowModal = mrOK then
  begin
    LEdit1.WordWrapRMargin := WWRMargin;
  end;
end;

procedure TLEditForm.WordWrapMenuItemClick(Sender: TObject);
var
  SL, EL: LongInt;
  SP, EP: Word;
begin
  { Get the current location }
  LEdit1.GetSelection;
  SL := LEdit1.StartLine;
  EL := LEdit1.EndLine;
  SP := LEdit1.StartPos;
  EP := LEdit1.EndPos;
  { Toggle LEdit to Word Wrap mode }
  WordWrapMenuItem.Checked := not WordWrapMenuItem.Checked;
  LEdit1.WordWrap := not LEdit1.WordWrap;
  { Set it back to the same position }
  LEdit1.StartLine := SL;
  LEdit1.EndLine := EL;
  LEdit1.StartPos := SP;
  LEdit1.EndPos := EP;
  LEdit1.SetSelection;
end;

procedure TLEditForm.CaretWidthMenuItemClick(Sender: TObject);
begin
  CaretWidthForm.CaretWidthEdit.Text := IntToStr(LEdit1.CaretWidth);
  if CaretWidthForm.ShowModal = mrOK then
  begin
    LEdit1.CaretWidth := FCaretWidth;
  end;
end;

procedure TLEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if LEdit1.Modified then
    if MessageDlg('The text has been modified.  Save?', mtInformation, [mbYes, mbNo], 0) = mrYes then
    begin
      LEdit1.SaveFile;
    end;
end;

procedure TLEditForm.Print1Click(Sender: TObject);
begin
  Print1.Checked := not Print1.Checked;
  LEdit1.NoPrintDialog := not Print1.Checked;
end;

procedure TLEditForm.PrintProgress1Click(Sender: TObject);
begin
  PrintProgress1.Checked := not PrintProgress1.Checked;
  LEdit1.NoPrintProgress := not PrintProgress1.Checked;
end;

end.
